﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

//access resource.resx
using System.Resources;

//our data access class library
using DataAccess;

public class CPatientAdmissionXfer : CData
{
    /// <summary>
    /// US:6006 constructor
    /// </summary>
    /// <param name="data"></param>
    public CPatientAdmissionXfer(CData data)
        : base(data)
    {
        //constructors are not inherited in c#!
    }

    /// <summary>
    /// US:6006 save a patient admission to the central database
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="pdi"></param>
    /// <returns></returns>
    public CStatus SavePatientAdmission(long lXferSystemID,
                                        CPatientAdmissionItemXfer pdi)
    {
        //check the patient id
        if (pdi == null || pdi.AdmitLocationID < 1)
        {
            return new CStatus(false, k_STATUS_CODE.Failed, "Could not save admission, invalid data!"); ;
        }

        //check the data connection
        CStatus status = DBConnValid();
        if (!status.Status)
        {
            return status;
        }

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(SessionID, ClientIP, UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_nRegionID", this.RegionID);
        pList.AddInputParameter("pi_nSiteID", this.SiteID);
        pList.AddInputParameter("pi_vDFN", pdi.DFN);

        pList.AddInputParameter("pi_nAdmitLocationID", pdi.AdmitLocationID);
        pList.AddInputParameter("pi_vAdmitLocationName", pdi.AdmitLocationName);
        pList.AddInputParameter("pi_vAdmitType", pdi.AdmitType);
        pList.AddInputParameter("pi_vAdmitTimeStamp", pdi.AdmitTimeStamp);
        pList.AddInputParameter("pi_vDischargeTimeStamp", pdi.AdmitDischargeTimeStamp);

        //execute the transfer SP
        CStatus statusXfer = DBConn.ExecuteOracleSP("PCK_XFER.XferPatientAdmission", pList);
        if (statusXfer.Status)
        {
            //good to go
        }

        return statusXfer;
    }

}
